jQuery(function($){

	$.fn.fmatter.paralizado = function(cellval,opts, rwd) {	
		var str = "";
		if (rwd.paralizado == "1"){
			str = "<div align='center'>Si</span></div>";
		}else{
			str = "<div align='center'>No</span></div>";
		}
		return str;
	};
	
	$("#RUP_GRID_peticion").hide();
	
	//Definición del grid de documentos
	$("#GRID_peticion").rup_grid({
		url: $.rup.CTX_PATH+"monitor/peticiones/tabla",
		loadOnStartUp: false,
		pagerName: "pagerPeticiones",
		autowidth: true,
		rowNum: "10",
		sortable: true,
	    sortname: "idPeticion",
		colNames: [
		    $.rup.i18n.app.GRID_peticion.codExpediente,
		    $.rup.i18n.app.GRID_peticion.descBoletin,
		    $.rup.i18n.app.GRID_peticion.idPeticion,
		    $.rup.i18n.app.GRID_peticion.descTipoEnvio,
		    $.rup.i18n.app.GRID_peticion.fechaPublicacionProgramada,
		    $.rup.i18n.app.GRID_peticion.fechaPublicacion,
		    $.rup.i18n.app.GRID_peticion.estadoPublicacion,
		    "",
		    $.rup.i18n.app.GRID_peticion.paralizado
		],
		colModel: [
			{ name: "codExpediente"},
			{ name: "descBoletin"},
			{ name: "idPeticion", hidden: true},
			{ name: "descTipoEnvio"},
			{ name: "fechaProgramadaPublicacion",formatter:"date"},
			{ name: "fechaPublicacion",formatter:"date"},
			{ name: "estadoPeticion"},
			{ name: "idEstadoPeticion", hidden: true},
			{ name: "paralizado", formatter: "paralizado"}
		]
//	    ],
//	    postData:
//	    {
//	    	idExpediente:idExpediente,
//	    	idTablaDocumentos:TABLA_DOCUMENTOS_EXPEDIENTE_CONTRATACION
//	    }
	});//Fin definición del objeto tabla
	
	//Creamos el área de mensajes del formulario
	$("#feedbackMensajes").rup_feedback({
		type: "ok",
		closeLink: true,
		block: false,
		gotoTop: false
	});
	
	//Creamos el área de mensajes de la tabla de peticiones
	$("#feedbackMensajesTablaPeticiones").rup_feedback({
		type: "ok",
		closeLink: true,
		block: false,
		gotoTop: false
	});
	
	//Formulario de ajax para validar con el rup_validate
	var ajaxForm = {};
	
	var propertiesValidacion={
			feedback:$("#feedbackMensajes"),
			rules:{
				"fechaEnvioDesde":{date:true},
				"fechaEnvioHasta":{date:true},
				"fechaProgramadaPublicacionDesde":{date:true},
				"fechaProgramadaPublicacionHasta":{date:true},
				"fechaPublicacionDesde":{date:true},
				"fechaPublicacionHasta":{date:true},
				"ticketPeticion":{integer:true},
				"idPeticion":{integer:true}
			},
			submitHandler: function(){
				//Al pulsar buscar marcamos el flag para saber que estamos buscando
				hayBusqueda = true;
				//Mostramos la capa en la que sale el mensaje de cargando y de no hay registros en caso de que la búsqueda sea vacía
				$("#RUP_GRID_GRID_peticion_noRecords").show();

				varFechaDesde = $("#fechaEnvioDesde").rup_date("getRupValue");
				varFechaHasta = $("#fechaEnvioHasta").rup_date("getRupValue");
				varFechaProgramadaPublicacionDesde = $("#fechaProgramadaPublicacionDesde").rup_date("getRupValue");
				varFechaProgramadaPublicacionHasta = $("#fechaProgramadaPublicacionHasta").rup_date("getRupValue");
				varFechaPublicacionDesde = $("#fechaPublicacionDesde").rup_date("getRupValue");
				varFechaPublicacionHasta = $("#fechaPublicacionHasta").rup_date("getRupValue");
				varIdBoletin = $("#idBoletin").val();
				varIdTicketPeticion = $("#idTicketPeticion").val();
				varIdPeticion = $("#idPeticion").val();
				varIdEstadoPeticion = $("#idEstadoPeticion").val();
				varIdTipoEnvio = $("#idTipoPeticion").val();
				varIdEstadoTramitacion = $("#comboTramitacion").val();
				varCodExpediente = $("#codExpediente").val();
				varIdPoder = $("#idPoderAdjudicador").val();
				varIdEntidadTramitadora = $("#idEntidadTramitadora").val();
				varIdMesa = $("#idMesaContratacion").val();
				varIdEntidadImpulsora = $("#idEntidadImpulsora").val();
				varIdOrgano = $("#idOrganoContratacion").val();
				varIdAmbito = $("#comboAmbito").val();
				
				if ($('#chkParalizada:checked').length > 0) {
					varChkParalizada = 1;
				} else {
					varChkParalizada = 0;
				}
				
				
				//Construimos el objeto con los parámetros del filtro a enviar
				var filtro = {
						fechaEnvioDesde: varFechaDesde,
						fechaEnvioHasta: varFechaHasta,
						idBoletin: varIdBoletin,
						idTicketPeticion: varIdTicketPeticion,
						idPeticion: varIdPeticion,
						idEstadoPeticion: varIdEstadoPeticion,
						idTipoEnvio: varIdTipoEnvio,
						fechaProgramadaPublicacionDesde: varFechaProgramadaPublicacionDesde,
						fechaProgramadaPublicacionHasta: varFechaProgramadaPublicacionHasta,
						fechaPublicacionDesde: varFechaPublicacionDesde,
						fechaPublicacionHasta: varFechaPublicacionHasta,
						codExpediente: varCodExpediente,
						idEstadoTramitacion: varIdEstadoTramitacion,
						idPoder: varIdPoder,
						idEntidadTramitadora: varIdEntidadTramitadora,
						idMesa: varIdMesa,
						idEntidadImpulsora: varIdEntidadImpulsora,
						idOrgano: varIdOrgano,
						idAmbito: varIdAmbito,
						paralizada: varChkParalizada
				};
				
				//Le pasamos al objeto tabla el filtro
				$("#GRID_peticion").rup_grid("setGridParam",{postData: filtro});
				//$("#GRID_bandejaEntrada").rup_grid("setGridParam",{postData: $.rup_utils.unnestjson(form2object($("#FORMULARIO")[0]))});
				
				//Recargamos la tabla haciendo la petición al servidor
				$("#GRID_peticion").rup_grid("reloadGrid");		
			}
	};
	
	$("#FORMULARIO").rup_validate(propertiesValidacion);
	$("#FORMULARIO").ajaxForm(ajaxForm);
	
	/* Evento click botón limpiar filtro */
	$("#botonLimpiar").click(function(){
		fncLimpiarCampos("#filtroBusqueda");
		fncOcultarValidaciones("#feedbackMensajes");
		fncOcultarValidaciones("#feedbackMensajesTablaPeticiones");
		$("#chkParalizada").prop("checked", false);
		$("#RUP_GRID_peticion").hide();
		vaciarCombo("idOrganoContratacion");
		vaciarCombo("idEntidadImpulsora");
		vaciarCombo("idPoderAdjudicador");
	});
	
	/* Evento click botón buscar */
	$("#botonBuscar").click(function(){
		fncOcultarValidaciones("#feedbackMensajes");
		fncOcultarValidaciones("#feedbackMensajesTablaPeticiones");
		$("#FORMULARIO").submit();
		$("#RUP_GRID_peticion").show();
	});
	
	var idAmbito='0';
	var poderAdjudicador='0';
	$('#comboAmbito').rup_combo({
		source : [
			{i18nCaption: "alava", value:"2" },
			{i18nCaption: "gipuzkoa", value:"3" },
			{i18nCaption: "bizkaia", value:"4" },
			{i18nCaption: "CAPV", value:"1"},
			{i18nCaption: "otros", value:"5" }
			],
		orderedByValue:true,
	width: "200px",
	menuWidth: "200px",
	selected: idAmbito,	
	blank : "0"
	});
	
	if (idAmbito != '' && idAmbito!='0'){
		$("#idPoderAdjudicador").rup_combo({
			source : $.rup.CTX_PATH+"combo/poderAdjudicador?idAmbito="+selecAmbito,
			sourceParam:{style:"", label:"descripcion",value:"id"},
			width: "400px",
			menuWidth: "400px",
			method: 'GET',
			blank : "0",
			selected: poderAdjudicador
		});

		
		if (poderAdjudicador != '' && poderAdjudicador!='0'){
			$("#idEntidadImpulsora").rup_combo({
				source : $.rup.CTX_PATH+"combo/entidadImpulsora?idPoder=" + selecPoder+"&tipoDecreto="+1,
				sourceParam:{style:"", label:"descripcion",value:"id"},
				width: "400px",
				menuWidth:"400px",
				method: 'GET',
				blank:"0",
				selected: idEntidad
			});
			
			if(idEntidad != '' && idEntidad != '0'){
				$("#idOrganoContratacion").rup_combo({
					source : $.rup.CTX_PATH+"combo/organo?idEntidadImpulsora="+ selecEntidad,
					sourceParam:{style:"", label:"descripcion",value:"id"},
					width: "400px",
					menuWidth:"400px",
					method: 'GET',
					blank : "0",
					selected: idOrgano
				});
			} else {
				iniciarComboVacio("idOrganoContratacion");
			}
		} else {
			iniciarComboVacio("idEntidadImpulsora");
			iniciarComboVacio("idOrganoContratacion");
		}
	} else {
		iniciarComboVacio("idPoderAdjudicador");
		iniciarComboVacio("idEntidadImpulsora");
		iniciarComboVacio("idOrganoContratacion");
	}
	
	$("#comboAmbito").change(function(){
		var selecAmbito=$("#comboAmbito").val();
		if(selecAmbito != '' && selecAmbito != '0'){
		vaciarCombo("idPoderAdjudicador");
		vaciarCombo("idEntidadImpulsora");
		vaciarCombo("idOrganoContratacion");
			$("#idPoderAdjudicador").unbind("change");
			$("#idPoderAdjudicador").selectmenu("destroy");
			$("#idPoderAdjudicador").rup_combo({
				source : $.rup.CTX_PATH+"combo/poderAdjudicador?idAmbito="+selecAmbito,
				sourceParam:{style:"", label:"descripcion",value:"id"},
				width: "400px",
				menuWidth: "400px",
				method: 'GET',
				blank : "0"	
			});
			
			$("#idPoderAdjudicador").change(function(){
				var selecPoder = $("#idPoderAdjudicador").val();
					
				if(selecPoder != '' && selecPoder != '0'){
					vaciarCombo("idOrganoContratacion");
					vaciarCombo("idEntidadImpulsora");
					$("#idEntidadImpulsora").unbind("change");
					$("#idEntidadImpulsora").selectmenu("destroy");
					$("#idEntidadImpulsora").rup_combo({
						source : $.rup.CTX_PATH+"combo/entidadImpulsora?idPoder=" + selecPoder+"&tipoDecreto="+1,
						sourceParam:{style:"", label:"descripcion",value:"id"},
						width: "400px",
						menuWidth:"400px",
						method: 'GET',
						blank:"0",
						selected: "0"
					});
					
					$("#idEntidadImpulsora").change(function(){
						var selecEntidad= $("#idEntidadImpulsora").val();
						if(selecEntidad != '' && selecEntidad != '0'){
							
							$("#idOrganoContratacion").selectmenu("destroy");				
							$("#idOrganoContratacion").rup_combo({
								source : $.rup.CTX_PATH+"combo/organo?idEntidadImpulsora="+ selecEntidad,
								sourceParam:{style:"", label:"descripcion",value:"id"},
								width: "400px",
								menuWidth:"400px",
								method: 'GET',
								blank : "0",
								selected: "0"
							});
						} else {
							vaciarCombo("idOrganoContratacion");
						}
					
					});
				} else {
					vaciarCombo("idOrganoContratacion");
					vaciarCombo("idEntidadImpulsora");
				}
			});
		} else {
			vaciarCombo("idOrganoContratacion");
			vaciarCombo("idEntidadImpulsora");
			vaciarCombo("idPoderAdjudicador");
			
		}
	});
	
	/* Definición del combo de los boletines */
	$('#idBoletin').rup_combo({
		source : $.rup.CTX_PATH+"combo/tiposBoletin",
		sourceParam : {
			label:"t06Desc",
			value:"t06IdBoletin"
		},
		width: 260,
		blank:""
	});	
	
	/* Definición del combo de los tipos de petición */
	$('#idEstadoPeticion').rup_combo({
		source : $.rup.CTX_PATH+"combo/estadosPeticion",
		sourceParam : {
			label:"t11DescEstado",
			value:"t11IdEstado"
		},
		width: 260,
		blank:""
	});	
	
	/* Definición del combo de los estados de la petición */
	$('#idTipoPeticion').rup_combo({
		source : $.rup.CTX_PATH+"combo/tiposPeticion",
		sourceParam : {
			label:"t02Desc"+$.rup_utils.capitalizedLang(),
			value:"t02IdTipoEnvio"
		},
		width: 260,
		blank:""
	});	
	
	/* Definición del combo de los estados de la tramitación */
	$('#comboTramitacion').rup_combo({
		source : $.rup.CTX_PATH+"combo/estadosTramitacion",
		sourceParam : {
			label:"descEstadoTramitacion"+$.rup_utils.capitalizedLang(),
			value:"idEstadoTramitacion"
		},
		width: 260,
		ordered: true,
		orderedByValue: true,
		blank:""
	});	
	
	// Recuperamos los datos del usuario mediante el WS de perfil
	$.rup_ajax({
		url : $.rup.CTX_PATH+"combo/informacionUsuario",
		dataType: 'json',
	    contentType: 'application/json',
	    type: 'GET',
		async: false,
		error: function(xhr, ajaxOptions, thrownError) {
			$("#feedbackMensajes").rup_feedback("set", thrownError, "error");
		}
	});
	
	
	
	/* Definiciones RUP_DATE */
	$('#fechaEnvioDesde').rup_date();
	$('#fechaEnvioHasta').rup_date();
	$('#fechaPublicacionDesde').rup_date();
	$('#fechaPublicacionHasta').rup_date();
	$('#fechaProgramadaPublicacionDesde').rup_date();
	$('#fechaProgramadaPublicacionHasta').rup_date();
	
	/* Eventos click botones */
	$("#botonRenderizarPDF, #botonVisualizarLink, #botonParalizar, #botonReanudar, #botonXMLEnviado, #botonDescargarZip, #botonReactivar").click(function(){
		obtenerFila(this.id);
	});
	
	$("#botonDetalle").click(function(){
		verDetalle();
	});
});

/**
 * Función que renderiza el anuncio seleccionado en PDF
 */
function obtenerFila(idBoton) {
	//Obtenemos el número de fila seleccionada
	var numFila = $("#GRID_peticion").rup_grid("getGridParam", "selrow");
	if (numFila && numFila > 0) {
		//Obtenemos los datos de la fila seleccionada
		var filaModifDoc = $("#GRID_peticion").rup_grid("getRowData", numFila);
		var filaArray = $.rup_utils.jsontoarray(filaModifDoc);
		var idPeticion = filaModifDoc['idPeticion'];
		//blockUI_Cargando();
		if (idBoton === "botonRenderizarPDF") {
			if (filaModifDoc['estadoPeticion'] != 'Publicado') {
				$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.registro_no_publicado, "alert");
			} else {
				fncRenderizar(idPeticion, "comprobarAnuncio");
			}
		} else if (idBoton === "botonVisualizarLink") {
			if (filaModifDoc['estadoPeticion'] != 'Publicado') {
				$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.registro_no_publicado, "alert");
			} else {
				fncRenderizar(idPeticion, "visualizarLink");
			}
		} else if (idBoton === "botonParalizar") {
			if (obtenerEstado("botonParalizar")) {
				fncParalizarReanudar(idPeticion, 1, "paralizar");
			}
		} else if (idBoton === "botonReanudar") {
			if (obtenerEstado("botonReanudar")) {
				fncParalizarReanudar(idPeticion, 0, "reanudar");
			}
		} else if (idBoton === "botonXMLEnviado") {
			fncDescargarEnviado(idPeticion, "descargarEnviado");
		} else if (idBoton === "botonDescargarZip") {
			fncDescargarEnviado(idPeticion, "descargarZip");
		} else if (idBoton === "botonReactivar") {
			if (filaModifDoc['idEstadoPeticion'] != 6 && filaModifDoc['idEstadoPeticion'] != 9) {
				$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.peticion_no_reactivar, "alert");
			} else {
				fncReactivarPeticion(idPeticion);
			}
		}
		
	} else {
		$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.debe_seleccionar_registro, "alert");
	}
}

function obtenerEstado(idBoton) {
	
	//Obtenemos el número de fila seleccionada
	var numFila = $("#GRID_peticion").rup_grid("getGridParam", "selrow");
	if (numFila && numFila > 0) {
		//Obtenemos los datos de la fila seleccionada
		var filaModifDoc = $("#GRID_peticion").rup_grid("getRowData", numFila);
		var filaArray = $.rup_utils.jsontoarray(filaModifDoc);
		var idPeticion = filaModifDoc['idPeticion'];
		var idEstado = filaModifDoc['idEstadoPeticion'];
		var paralizado = filaModifDoc['paralizado'];
		
		if (idBoton == 'botonParalizar') {
			if (idEstado == 1 && paralizado == 'No') {
				return true;
			} else {
				if (idEstado != 1) {
					$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.peticion_no_paralizable, "alert");
				} else if (paralizado == 'Si') {
					$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.peticion_ya_paralizada, "alert");
				}
				return false;
			}
		} else if (idBoton == 'botonReanudar') {
			if (paralizado == 'Si') {
				return true;
			} else {
				$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.peticion_no_paralizada, "alert");
				return false;
			}
		}
		
	}
} 

/**
 * Función que renderiza el anuncio en formato HTML o PDF
 */
function fncRenderizar(idPeticion, funcion) {
	$.rup_ajax({
		url : $.rup.CTX_PATH+"monitor/" + funcion,
		dataType: 'json',
	    type: 'GET',
		async: false,
		data: {idPeticion: idPeticion},
		success: function(resultado, ajaxOptions) {
			if (resultado) {
				if (funcion === "visualizarLink") {
					var arrayLength = resultado.length;
					for (var i = 0; i < arrayLength; i++) {
						window.open(resultado[i]);
					}
				} else {
					fncDescargarZipSubmit(idPeticion, "renderizarAnuncio");
				}
	    	}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			$("#feedbackMensajesTablaPeticiones").rup_feedback("set", xhr.responseText, "error");
		}
	});
}

function fncParalizarReanudar(idPeticion, paralizar, funcion) {
	$.rup_ajax({
		url : $.rup.CTX_PATH+"monitor/" + funcion,
		dataType: 'json',
	    contentType: 'application/json',
	    type: 'GET',
		async: false,
		data: {idPeticion: idPeticion, paralizar : paralizar},
		success: function(resultado, ajaxOptions) {
			if (funcion == "paralizar") {
				$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.peticion_paralizada, "ok");
			} else if (funcion == "reanudar"){
				$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.peticion_reanudada, "ok");
			}
			
			//Recargamos la tabla haciendo la petición al servidor
			$("#GRID_peticion").rup_grid("reloadGrid");		
		},
		error: function(xhr, ajaxOptions, thrownError) {
			//$.unblockUI();
			$("#feedbackMensajesMantenimiento").rup_feedback("set", xhr.responseText, "error");
		}
	});
}

/**
 * Función que hace un submit y envía un formulario para cargar el detalle
 * de petición
 */
function verDetalle(){
	//Obtenemos el número de fila seleccionada
	var numFila = $("#GRID_peticion").rup_grid("getGridParam", "selrow");
	if(numFila && numFila>0){
		//Obtenemos los datos de la fila seleccionada
		var filaPeticion = $("#GRID_peticion").rup_grid("getRowData",numFila);
		//Le asignamos al hidden del formulario 
		$("#hIdPeticion").attr("value",filaPeticion.idPeticion);
		//Controller que carga el detalle de la peticion
		$("#FORMULARIO_LISTADO_PETICIONES").attr('action', $.rup.CTX_PATH + 'monitor/peticion');
		$("#FORMULARIO_LISTADO_PETICIONES").attr('method', 'GET');
		$("#FORMULARIO_LISTADO_PETICIONES").submit();
	}
	else{
		$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.alert.debe_seleccionar_registro, "alert");
	}
}

function fncReactivarPeticion(idPeticion) {
	$.rup_ajax({
		url : $.rup.CTX_PATH+"monitor/reactivarPeticion",
	    type: 'POST',
		data: {idPeticion: idPeticion},
		success: function(resultado, ajaxOptions) {
			$("#feedbackMensajesTablaPeticiones").rup_feedback("set", $.rup.i18n.app.mensajes.alert.peticion_reactivada, "ok");
			
			//Recargamos la tabla haciendo la petición al servidor
			$("#GRID_peticion").rup_grid("reloadGrid");
		},
		error: function(data, ajaxOptions, thrownError) {
					$("#feedbackMensajesTablaPeticiones").rup_feedback("set", data.responseText, "error");
		}
	});
}

function fncDescargarEnviado(idPeticion, funcion) {
	$.rup_ajax({
		url : $.rup.CTX_PATH+"monitor/" + funcion,
	    type: 'GET',
		data: {idPeticion: idPeticion},
		success: function(resultado, ajaxOptions) {
			if (resultado) {
				if (funcion == "") {
					window.open(resultado);
				} else {
					if (funcion == "descargarZip") {
						fncDescargarZipSubmit(idPeticion, funcion);
					} else {
						if (navigator.msSaveBlob) { // IE 10+
							var str = resultado.replace(/\"/g, "");
							navigator.msSaveBlob(new Blob([atob(str)], { type: 'text/xml;base64;' }), "xmlEnviado.xml");
						} else {
							var str = resultado.replace(/\"/g, "");
							var link = document.createElement('a');
					        document.body.appendChild(link); 
					        link.download = "xmlEnviado.xml";
					        link.href = "data:text/xml;base64," + str;
					        link.click();
					        document.body.removeChild(link); 
						}
						
					}
				}
				
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
				$("#feedbackMensajesTablaPeticiones").rup_feedback("set", xhr.responseText, "error");
		}
	});
}

function fncDescargarZipSubmit(idPeticion, funcion) {
	$("#hIdPeticionZip").val(idPeticion);
	$("#FORMULARIO_ZIP").attr('action', $.rup.CTX_PATH + 'monitor/' + funcion);
	$("#FORMULARIO_ZIP").attr('method', 'GET');
	document.getElementById("FORMULARIO_ZIP").submit();
}

function b64toBlob(b64Data, contentType, sliceSize) {
	  contentType = contentType || '';
	  sliceSize = sliceSize || 512;

	  var byteCharacters = atob(b64Data);
	  var byteArrays = [];

	  for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
	    var slice = byteCharacters.slice(offset, offset + sliceSize);

	    var byteNumbers = new Array(slice.length);
	    for (var i = 0; i < slice.length; i++) {
	      byteNumbers[i] = slice.charCodeAt(i);
	    }

	    var byteArray = new Uint8Array(byteNumbers);

	    byteArrays.push(byteArray);
	  }

	  var blob = new Blob(byteArrays, {type: contentType});
	  return blob;
	}

function vaciarCombo(idCombo){
	$("#"+idCombo).rup_combo("select","0");
	$("#"+idCombo).empty().selectmenu("disable");
	$("#" +idCombo+ "-button span:first-child").text("");
}

function iniciarComboVacio(idCombo){
	$("#"+idCombo).rup_combo({
		source : [],
		width: "400px",
		menuWidth: "400px",
		blank: "0"	
		
	});
	vaciarCombo(idCombo);
}